#ifndef __ECAT_DPM_ERROR_H
#define __ECAT_DPM_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// Ecat Slave DPM Application  Task
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECAT_DPM_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_ECAT_DPM_COMMAND_INVALID   ((TLR_RESULT)0xC04C0001L)

//
// MessageId: TLR_E_ECAT_DPM_INVALID_IO_SIZE
//
// MessageText:
//
//  Invalid I/O size has been tried to be configured.
//
#define TLR_E_ECAT_DPM_INVALID_IO_SIZE   ((TLR_RESULT)0xC04C0002L)

//
// MessageId: TLR_E_ECAT_DPM_WATCHDOG_TIMEOUT_EXPIRED
//
// MessageText:
//
//  Watchdog timeout expired.
//
#define TLR_E_ECAT_DPM_WATCHDOG_TIMEOUT_EXPIRED ((TLR_RESULT)0xC04C0003L)

//
// MessageId: TLR_E_ECAT_DPM_INVALID_WATCHDOG_TIME
//
// MessageText:
//
//  Invalid Watchdog time has been tried to be configured.
//
#define TLR_E_ECAT_DPM_INVALID_WATCHDOG_TIME ((TLR_RESULT)0xC04C0004L)

//
// MessageId: TLR_E_ECAT_DPM_INVALID_IO_SIZE_2
//
// MessageText:
//
//  Invalid I/O size has been tried to be configured.
//
#define TLR_E_ECAT_DPM_INVALID_IO_SIZE_2 ((TLR_RESULT)0xC04C0005L)

//
// MessageId: TLR_E_ECAT_DPM_INVALID_IO_SIZE_3
//
// MessageText:
//
//  Invalid I/O size has been tried to be configured.
//
#define TLR_E_ECAT_DPM_INVALID_IO_SIZE_3 ((TLR_RESULT)0xC04C0006L)

//
// MessageId: TLR_E_ECAT_DPM_INVALID_IO_SIZE_4
//
// MessageText:
//
//  Invalid I/O size has been tried to be configured.
//
#define TLR_E_ECAT_DPM_INVALID_IO_SIZE_4 ((TLR_RESULT)0xC04C0007L)

//
// MessageId: TLR_E_ECAT_DPM_BUS_SYNCHRONOUS_NOT_SUPPORTED
//
// MessageText:
//
//  Bus Synchronous Mode is not supported.
//
#define TLR_E_ECAT_DPM_BUS_SYNCHRONOUS_NOT_SUPPORTED ((TLR_RESULT)0xC04C0008L)

//
// MessageId: TLR_E_ECAT_DPM_UPDATE_CFG_SM2_UPDATE_PARAMETER_IS_INVALID
//
// MessageText:
//
//  Sm2 Update Parameter is invalid.
//
#define TLR_E_ECAT_DPM_UPDATE_CFG_SM2_UPDATE_PARAMETER_IS_INVALID ((TLR_RESULT)0xC04C0009L)

//
// MessageId: TLR_E_ECAT_DPM_UPDATE_CFG_SM3_UPDATE_PARAMETER_IS_INVALID
//
// MessageText:
//
//  Sm2 Update Parameter is invalid.
//
#define TLR_E_ECAT_DPM_UPDATE_CFG_SM3_UPDATE_PARAMETER_IS_INVALID ((TLR_RESULT)0xC04C000AL)

//
// MessageId: TLR_E_ECAT_DPM_UPDATE_CFG_BUS_SYNC_UPDATE_PARAMETER_IS_INVALID
//
// MessageText:
//
//  Bus-Sync Update Parameter is invalid.
//
#define TLR_E_ECAT_DPM_UPDATE_CFG_BUS_SYNC_UPDATE_PARAMETER_IS_INVALID ((TLR_RESULT)0xC04C000BL)

//
// MessageId: TLR_E_ECAT_AP_REQUEST_ABORTED
//
// MessageText:
//
//  Request has been aborted.
//
#define TLR_E_ECAT_AP_REQUEST_ABORTED    ((TLR_RESULT)0xC04C000CL)

//
// MessageId: TLR_E_ECAT_AP_NXD_GENERAL_ERROR
//
// MessageText:
//
//  Unknown error while parsing database.
//
#define TLR_E_ECAT_AP_NXD_GENERAL_ERROR  ((TLR_RESULT)0xC04C000DL)

//
// MessageId: TLR_E_ECAT_AP_NXD_NOT_AVAILABLE
//
// MessageText:
//
//  No database available.
//
#define TLR_E_ECAT_AP_NXD_NOT_AVAILABLE  ((TLR_RESULT)0xC04C000EL)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_NXD_TYPE
//
// MessageText:
//
//  Not an EtherCAT slave database.
//
#define TLR_E_ECAT_AP_NXD_INVALID_NXD_TYPE ((TLR_RESULT)0xC04C000FL)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_STRUCTURE
//
// MessageText:
//
//  Invalid database structure.
//
#define TLR_E_ECAT_AP_NXD_INVALID_STRUCTURE ((TLR_RESULT)0xC04C0010L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_NXD_VERSION
//
// MessageText:
//
//  Database version not supported.
//
#define TLR_E_ECAT_AP_NXD_INVALID_NXD_VERSION ((TLR_RESULT)0xC04C0011L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_ECS_CONFIG
//
// MessageText:
//
//  Invalid stack configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_ECS_CONFIG ((TLR_RESULT)0xC04C0012L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_SM_CONFIG
//
// MessageText:
//
//  Invalid Sync Manager configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_SM_CONFIG ((TLR_RESULT)0xC04C0013L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_SM0_CONFIG
//
// MessageText:
//
//  Invalid Sync Manager 0 configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_SM0_CONFIG ((TLR_RESULT)0xC04C0014L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_SM1_CONFIG
//
// MessageText:
//
//  Invalid Sync Manager 1 configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_SM1_CONFIG ((TLR_RESULT)0xC04C0015L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_SM2_CONFIG
//
// MessageText:
//
//  Invalid Sync Manager 2 configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_SM2_CONFIG ((TLR_RESULT)0xC04C0016L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_SM3_CONFIG
//
// MessageText:
//
//  Invalid Sync Manager 3 configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_SM3_CONFIG ((TLR_RESULT)0xC04C0017L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_SM4_CONFIG
//
// MessageText:
//
//  Invalid Sync Manager 4 configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_SM4_CONFIG ((TLR_RESULT)0xC04C0018L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_SM5_CONFIG
//
// MessageText:
//
//  Invalid Sync Manager 5 configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_SM5_CONFIG ((TLR_RESULT)0xC04C0019L)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_SM6_CONFIG
//
// MessageText:
//
//  Invalid Sync Manager 6 configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_SM6_CONFIG ((TLR_RESULT)0xC04C001AL)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_SM7_CONFIG
//
// MessageText:
//
//  Invalid Sync Manager 7 configuration.
//
#define TLR_E_ECAT_AP_NXD_INVALID_SM7_CONFIG ((TLR_RESULT)0xC04C001BL)

//
// MessageId: TLR_E_ECAT_AP_NXD_INVALID_HSK_CONFIG
//
// MessageText:
//
//  Invalid configuration of process data handshakes.
//
#define TLR_E_ECAT_AP_NXD_INVALID_HSK_CONFIG ((TLR_RESULT)0xC04C001CL)




#endif  //__ECAT_DPM_ERROR_H

